/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.command.GroupNameSuggestionProvider;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.permission.Permission;
import de.maxhenkel.voicechat.permission.PermissionManager;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.server.ClientConnection;
import de.maxhenkel.voicechat.voice.server.Group;
import de.maxhenkel.voicechat.voice.server.PingManager;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.level.ServerPlayer;

public class VoicechatCommands {
    public static final String VOICECHAT_COMMAND = "voicechat";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder literalBuilder = Commands.literal((String)VOICECHAT_COMMAND);
        literalBuilder.executes(commandSource -> VoicechatCommands.help(dispatcher, (CommandContext<CommandSourceStack>)commandSource));
        literalBuilder.then(Commands.literal((String)"help").executes(commandSource -> VoicechatCommands.help(dispatcher, (CommandContext<CommandSourceStack>)commandSource)));
        literalBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)"test").requires(commandSource -> VoicechatCommands.checkPermission(commandSource, PermissionManager.INSTANCE.ADMIN_PERMISSION))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<CommandSourceStack>)commandSource)) {
                return 0;
            }
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)commandSource, (String)"target");
            Server server = Voicechat.SERVER.getServer();
            if (server == null) {
                ((CommandSourceStack)commandSource.getSource()).sendSuccess(() -> Component.translatable((String)"message.voicechat.voice_chat_unavailable"), false);
                return 1;
            }
            if (!Voicechat.SERVER.isCompatible(player)) {
                ((CommandSourceStack)commandSource.getSource()).sendSuccess(() -> Component.translatable((String)"message.voicechat.player_no_voicechat", (Object[])new Object[]{player.getDisplayName(), CommonCompatibilityManager.INSTANCE.getModName()}), false);
                return 1;
            }
            ClientConnection clientConnection = server.getConnections().get(player.getUUID());
            if (clientConnection == null) {
                ((CommandSourceStack)commandSource.getSource()).sendSuccess(() -> Component.translatable((String)"message.voicechat.client_not_connected"), false);
                return 1;
            }
            try {
                ((CommandSourceStack)commandSource.getSource()).sendSuccess(() -> Component.translatable((String)"message.voicechat.sending_ping"), false);
                server.getPingManager().sendPing(clientConnection, 500L, 10, new PingManager.PingListener(){

                    @Override
                    public void onPong(int attempts, long pingMilliseconds) {
                        if (attempts <= 1) {
                            ((CommandSourceStack)commandSource.getSource()).sendSuccess(() -> Component.translatable((String)"message.voicechat.ping_received", (Object[])new Object[]{pingMilliseconds}), false);
                        } else {
                            ((CommandSourceStack)commandSource.getSource()).sendSuccess(() -> Component.translatable((String)"message.voicechat.ping_received_attempt", (Object[])new Object[]{pingMilliseconds, attempts}), false);
                        }
                    }

                    @Override
                    public void onFailedAttempt(int attempts) {
                        ((CommandSourceStack)commandSource.getSource()).sendSuccess(() -> Component.translatable((String)"message.voicechat.ping_retry"), false);
                    }

                    @Override
                    public void onTimeout(int attempts) {
                        ((CommandSourceStack)commandSource.getSource()).sendSuccess(() -> Component.translatable((String)"message.voicechat.ping_timed_out", (Object[])new Object[]{attempts}), false);
                    }
                });
                ((CommandSourceStack)commandSource.getSource()).sendSuccess(() -> Component.translatable((String)"message.voicechat.ping_sent_waiting"), false);
            }
            catch (Exception e) {
                ((CommandSourceStack)commandSource.getSource()).sendSuccess(() -> Component.translatable((String)"message.voicechat.failed_to_send_ping", (Object[])new Object[]{e.getMessage()}), false);
                Voicechat.LOGGER.warn("Failed to send ping", e);
                return 1;
            }
            return 1;
        })));
        literalBuilder.then(Commands.literal((String)"invite").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<CommandSourceStack>)commandSource)) {
                return 0;
            }
            ServerPlayer source = ((CommandSourceStack)commandSource.getSource()).getPlayerOrException();
            Server server = Voicechat.SERVER.getServer();
            if (server == null) {
                ((CommandSourceStack)commandSource.getSource()).sendSuccess(() -> Component.translatable((String)"message.voicechat.voice_chat_unavailable"), false);
                return 1;
            }
            PlayerState state = server.getPlayerStateManager().getState(source.getUUID());
            if (state == null || !state.hasGroup()) {
                ((CommandSourceStack)commandSource.getSource()).sendSuccess(() -> Component.translatable((String)"message.voicechat.not_in_group"), false);
                return 1;
            }
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)commandSource, (String)"target");
            Group group = server.getGroupManager().getGroup(state.getGroup());
            if (group == null) {
                return 1;
            }
            if (!Voicechat.SERVER.isCompatible(player)) {
                ((CommandSourceStack)commandSource.getSource()).sendSuccess(() -> Component.translatable((String)"message.voicechat.player_no_voicechat", (Object[])new Object[]{player.getDisplayName(), CommonCompatibilityManager.INSTANCE.getModName()}), false);
                return 1;
            }
            String passwordSuffix = group.getPassword() == null ? "" : " \"" + group.getPassword() + "\"";
            player.sendSystemMessage((Component)Component.translatable((String)"message.voicechat.invite", (Object[])new Object[]{source.getDisplayName(), Component.literal((String)group.getName()).withStyle(ChatFormatting.GRAY), ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"message.voicechat.accept_invite").withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.RunCommand("/voicechat join " + group.getId().toString() + passwordSuffix)).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.translatable((String)"message.voicechat.accept_invite.hover"))))).withStyle(ChatFormatting.GREEN)}));
            ((CommandSourceStack)commandSource.getSource()).sendSuccess(() -> Component.translatable((String)"message.voicechat.invite_successful", (Object[])new Object[]{player.getDisplayName()}), false);
            return 1;
        })));
        literalBuilder.then(Commands.literal((String)"join").then(Commands.argument((String)"group_id", (ArgumentType)UuidArgument.uuid()).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<CommandSourceStack>)commandSource)) {
                return 0;
            }
            UUID groupID = UuidArgument.getUuid((CommandContext)commandSource, (String)"group_id");
            return VoicechatCommands.joinGroupById((CommandSourceStack)commandSource.getSource(), groupID, null);
        })));
        literalBuilder.then(Commands.literal((String)"join").then(Commands.argument((String)"group_id", (ArgumentType)UuidArgument.uuid()).then(Commands.argument((String)"password", (ArgumentType)StringArgumentType.string()).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<CommandSourceStack>)commandSource)) {
                return 0;
            }
            UUID groupID = UuidArgument.getUuid((CommandContext)commandSource, (String)"group_id");
            String password = StringArgumentType.getString((CommandContext)commandSource, (String)"password");
            return VoicechatCommands.joinGroupById((CommandSourceStack)commandSource.getSource(), groupID, password.isEmpty() ? null : password);
        }))));
        literalBuilder.then(Commands.literal((String)"join").then(Commands.argument((String)"group_name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)GroupNameSuggestionProvider.INSTANCE).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<CommandSourceStack>)commandSource)) {
                return 0;
            }
            String groupName = StringArgumentType.getString((CommandContext)commandSource, (String)"group_name");
            return VoicechatCommands.joinGroupByName((CommandSourceStack)commandSource.getSource(), groupName, null);
        })));
        literalBuilder.then(Commands.literal((String)"join").then(Commands.argument((String)"group_name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)GroupNameSuggestionProvider.INSTANCE).then(Commands.argument((String)"password", (ArgumentType)StringArgumentType.string()).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<CommandSourceStack>)commandSource)) {
                return 0;
            }
            String groupName = StringArgumentType.getString((CommandContext)commandSource, (String)"group_name");
            String password = StringArgumentType.getString((CommandContext)commandSource, (String)"password");
            return VoicechatCommands.joinGroupByName((CommandSourceStack)commandSource.getSource(), groupName, password.isEmpty() ? null : password);
        }))));
        literalBuilder.then(Commands.literal((String)"leave").executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<CommandSourceStack>)commandSource)) {
                return 0;
            }
            if (!Voicechat.SERVER_CONFIG.groupsEnabled.get().booleanValue()) {
                ((CommandSourceStack)commandSource.getSource()).sendFailure((Component)Component.translatable((String)"message.voicechat.groups_disabled"));
                return 1;
            }
            Server server = Voicechat.SERVER.getServer();
            if (server == null) {
                ((CommandSourceStack)commandSource.getSource()).sendSuccess(() -> Component.translatable((String)"message.voicechat.voice_chat_unavailable"), false);
                return 1;
            }
            ServerPlayer source = ((CommandSourceStack)commandSource.getSource()).getPlayerOrException();
            PlayerState state = server.getPlayerStateManager().getState(source.getUUID());
            if (state == null || !state.hasGroup()) {
                ((CommandSourceStack)commandSource.getSource()).sendSuccess(() -> Component.translatable((String)"message.voicechat.not_in_group"), false);
                return 1;
            }
            server.getGroupManager().leaveGroup(source);
            ((CommandSourceStack)commandSource.getSource()).sendSuccess(() -> Component.translatable((String)"message.voicechat.leave_successful"), false);
            return 1;
        }));
        dispatcher.register(literalBuilder);
    }

    private static Server joinGroup(CommandSourceStack source) throws CommandSyntaxException {
        if (!Voicechat.SERVER_CONFIG.groupsEnabled.get().booleanValue()) {
            source.sendFailure((Component)Component.translatable((String)"message.voicechat.groups_disabled"));
            return null;
        }
        Server server = Voicechat.SERVER.getServer();
        if (server == null) {
            source.sendSuccess(() -> Component.translatable((String)"message.voicechat.voice_chat_unavailable"), false);
            return null;
        }
        ServerPlayer player = source.getPlayerOrException();
        if (!PermissionManager.INSTANCE.GROUPS_PERMISSION.hasPermission(player)) {
            source.sendSuccess(() -> Component.translatable((String)"message.voicechat.no_group_permission"), false);
            return null;
        }
        return server;
    }

    private static int joinGroupByName(CommandSourceStack source, String groupName, @Nullable String password) throws CommandSyntaxException {
        Server server = VoicechatCommands.joinGroup(source);
        if (server == null) {
            return 1;
        }
        List groups = server.getGroupManager().getGroups().values().stream().filter(group -> group.getName().equals(groupName)).collect(Collectors.toList());
        if (groups.isEmpty()) {
            source.sendFailure((Component)Component.translatable((String)"message.voicechat.group_does_not_exist"));
            return 1;
        }
        if (groups.size() > 1) {
            source.sendFailure((Component)Component.translatable((String)"message.voicechat.group_name_not_unique"));
            return 1;
        }
        return VoicechatCommands.joinGroup(source, server, ((Group)groups.get(0)).getId(), password);
    }

    private static int joinGroupById(CommandSourceStack source, UUID groupID, @Nullable String password) throws CommandSyntaxException {
        Server server = VoicechatCommands.joinGroup(source);
        if (server == null) {
            return 1;
        }
        return VoicechatCommands.joinGroup(source, server, groupID, password);
    }

    private static int joinGroup(CommandSourceStack source, Server server, UUID groupID, @Nullable String password) throws CommandSyntaxException {
        Group group = server.getGroupManager().getGroup(groupID);
        if (group == null) {
            source.sendFailure((Component)Component.translatable((String)"message.voicechat.group_does_not_exist"));
            return 1;
        }
        server.getGroupManager().joinGroup(group, source.getPlayerOrException(), password);
        source.sendSuccess(() -> Component.translatable((String)"message.voicechat.join_successful", (Object[])new Object[]{Component.literal((String)group.getName()).withStyle(ChatFormatting.GRAY)}), false);
        return 1;
    }

    private static int help(CommandDispatcher<CommandSourceStack> dispatcher, CommandContext<CommandSourceStack> commandSource) {
        if (VoicechatCommands.checkNoVoicechat(commandSource)) {
            return 0;
        }
        CommandNode voicechatCommand = dispatcher.getRoot().getChild(VOICECHAT_COMMAND);
        Map map = dispatcher.getSmartUsage(voicechatCommand, (Object)((CommandSourceStack)commandSource.getSource()));
        for (Map.Entry entry : map.entrySet()) {
            ((CommandSourceStack)commandSource.getSource()).sendSuccess(() -> Component.literal((String)"/%s %s".formatted(VOICECHAT_COMMAND, entry.getValue())), false);
        }
        return map.size();
    }

    private static boolean checkNoVoicechat(CommandContext<CommandSourceStack> commandSource) {
        try {
            ServerPlayer player = ((CommandSourceStack)commandSource.getSource()).getPlayerOrException();
            if (Voicechat.SERVER.isCompatible(player)) {
                return false;
            }
            ((CommandSourceStack)commandSource.getSource()).sendFailure((Component)Component.literal((String)Voicechat.TRANSLATIONS.voicechatNeededForCommandMessage.get().formatted(CommonCompatibilityManager.INSTANCE.getModName())));
            return true;
        }
        catch (Exception e) {
            ((CommandSourceStack)commandSource.getSource()).sendFailure((Component)Component.literal((String)Voicechat.TRANSLATIONS.playerCommandMessage.get()));
            return true;
        }
    }

    private static boolean checkPermission(CommandSourceStack stack, Permission permission) {
        try {
            return permission.hasPermission(stack.getPlayerOrException());
        }
        catch (CommandSyntaxException e) {
            return stack.hasPermission(stack.getServer().operatorUserPermissionLevel());
        }
    }
}

